//
//  Webcall.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 04/07/2022.
//

import Foundation

class WebserviceCall {
    static func webcall(urlString: UnsafeMutablePointer<CChar>?, timeout: Int32, user: UnsafeMutableRawPointer!) -> Int32 {

        guard let urlString = urlString,
              let path = String(cString: urlString, encoding: .isoLatin1),
              let url = URL(string: path) else {
            return 1
        }
        var request = URLRequest(url: url)
        request.timeoutInterval = TimeInterval(timeout)
        request.httpMethod = "GET"

        let response: (data: Data?, response: URLResponse?, error: Error?) = URLSession.shared.syncRequest(with: request)
        if let data = response.data {
            let length = data.count
            let buffer = UnsafeMutableRawBufferPointer.allocate(byteCount: length, alignment: MemoryLayout<CChar>.alignment)
            data.copyBytes(to: buffer)
            IWSetWsBuffer(
                user.bindMemory(to: IW.self, capacity: MemoryLayout.size(ofValue: user)),
                buffer.baseAddress?.bindMemory(to: CChar.self, capacity: length))
            return 0
        } else if let error = response.error {
            print("An error occured: \(error)")
            return 1
        }
        return 1
    }
}

extension URLSession {
    func syncRequest(with request: URLRequest) -> (Data?, URLResponse?, Error?) {
          var data: Data?
          var response: URLResponse?
          var error: Error?
          
          let dispatchGroup = DispatchGroup()
          let task = dataTask(with: request) {
             data = $0
             response = $1
             error = $2
             dispatchGroup.leave()
          }
          dispatchGroup.enter()
          task.resume()
          dispatchGroup.wait()
          
          return (data, response, error)
       }
}
